/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.plant;

import com.agricraft.agricraft.api.plant.AgriPlantModifierFactory;
import com.agricraft.agricraft.api.plant.AgriPlantModifierInfo;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AgriPlantModifierFactoryRegistry {
    private static final Map<String, AgriPlantModifierFactory> FACTORIES = new HashMap<String, AgriPlantModifierFactory>();

    public static boolean register(String id, AgriPlantModifierFactory modifier) {
        if (FACTORIES.containsKey(id)) {
            return false;
        }
        FACTORIES.put(id, modifier);
        return true;
    }

    public static Optional<AgriPlantModifierFactory> get(String id) {
        return Optional.ofNullable(FACTORIES.get(id));
    }

    public static Optional<AgriPlantModifierFactory> get(AgriPlantModifierInfo modifier) {
        return Optional.ofNullable(FACTORIES.get(modifier.id()));
    }

    public static Optional<IAgriPlantModifier> construct(AgriPlantModifierInfo info) {
        return AgriPlantModifierFactoryRegistry.get(info).flatMap(factory -> factory.construct(info));
    }
}

